﻿//////////////////////////////////////////////
// Endianness.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Internals --------------------------------

namespace nkImages
{
	enum class ENDIAN
	{
		ENDIAN_LITTLE = 0,
		ENDIAN_BIG
	} ;
}

/// Includes ---------------------------------

// Standards
#include <inttypes.h>

/// Class ------------------------------------

namespace nkImages
{
	class Endianness final
	{
		public :

			static ENDIAN getEndianness ()
			{
				union
				{
					char c [4] ;
					uint32_t i = 0x00111155 ;
				} data ;

				return data.c[0] == 0x55 ? ENDIAN::ENDIAN_LITTLE : ENDIAN::ENDIAN_BIG ;
			}

		private :

			// Constructorr, destructorr
			Endianness () ;
			~Endianness () ;
	} ;
}